---
title: WAF Release - 2025-09-08 · Changelog
description: Cloudflare WAF managed rulesets 2025-09-08 release
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-08-waf-release/
  md: https://developers.cloudflare.com/changelog/2025-09-08-waf-release/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## WAF Release - 2025-09-08

Sep 08, 2025

[WAF](https://developers.cloudflare.com/waf/)

**This week's update**

This week’s focus highlights newly disclosed vulnerabilities in web frameworks, enterprise applications, and widely deployed CMS plugins. The vulnerabilities include SSRF, authentication bypass, arbitrary file upload, and remote code execution (RCE), exposing organizations to high-impact risks such as unauthorized access, system compromise, and potential data exposure. In addition, security rule enhancements have been deployed to cover general command injection and server-side injection attacks, further strengthening protections.

**Key Findings**

* Next.js (CVE-2025-57822): Improper handling of redirects in custom middleware can lead to server-side request forgery (SSRF) when user-supplied headers are forwarded. Attackers could exploit this to access internal services or cloud metadata endpoints. The issue has been resolved in versions 14.2.32 and 15.4.7. Developers using custom middleware should upgrade and verify proper redirect handling in `next()` calls.

* ScriptCase (CVE-2025-47227, CVE-2025-47228): In the Production Environment extension in Netmake ScriptCase through 9.12.006 (23), two vulnerabilities allow attackers to reset admin accounts and execute system commands, potentially leading to full compromise of affected deployments.

* Sar2HTML (CVE-2025-34030): In Sar2HTML version 3.2.2 and earlier, insufficient input sanitization of the plot parameter allows remote, unauthenticated attackers to execute arbitrary system commands. Exploitation could compromise the underlying server and its data.

* Zhiyuan OA (CVE-2025-34040): An arbitrary file upload vulnerability exists in the Zhiyuan OA platform. Improper validation in the `wpsAssistServlet` interface allows unauthenticated attackers to upload crafted files via path traversal, which can be executed on the web server, leading to remote code execution.

* WordPress:Plugin:InfiniteWP Client (CVE-2020-8772): A vulnerability in the InfiniteWP Client plugin allows attackers to perform restricted actions and gain administrative control of connected WordPress sites.

**Impact**

These vulnerabilities could allow attackers to gain unauthorized access, execute malicious code, or take full control of affected systems. The Next.js SSRF flaw may expose internal services or cloud metadata endpoints to attackers. Exploitations of ScriptCase and Sar2HTML could result in remote code execution, administrative takeover, and full server compromise. In Zhiyuan OA, the arbitrary file upload vulnerability allows attackers to execute malicious code on the web server, potentially exposing sensitive data and applications. The authentication bypass in WordPress InfiniteWP Client enables attackers to gain administrative access, risking data exposure and unauthorized control of connected sites.

Administrators are strongly advised to apply vendor patches immediately, remove unsupported software, and review authentication and access controls to mitigate these risks.

| Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
| - | - | - | - | - | - | - |
| Cloudflare Managed Ruleset | 7c5812a31fd94996b3299f7e963d7afc | 100007D | Command Injection - Common Attack Commands Args | Log | Block | This rule has been merged into the original rule "Command Injection - Common Attack Commands" (ID: 89557ce9b26e4d4dbf29e90c28345b9b ) for New WAF customers only. |
| Cloudflare Managed Ruleset | cd528243d6824f7ab56182988230a75b | 100617 | Next.js - SSRF - CVE:CVE-2025-57822 | Log | Block | This is a New Detection |
| Cloudflare Managed Ruleset | 503b337dac5c409d8f833a6ba22dabf1 | 100659\_BETA | Common Payloads for Server-Side Template Injection - Beta | Log | Block | This rule is merged into the original rule "Common Payloads for Server-Side Template Injection" (ID: 21c7a963e1b749e7b1753238a28a42c4 ) |
| Cloudflare Managed Ruleset | 6d24266148f24f5e9fa487f8b416b7ca | 100824B | CrushFTP - Remote Code Execution - CVE:CVE-2025-54309 - 3 | Log | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | 154b217c43d04f11a13aeff05db1fa6b | 100848 | ScriptCase - Auth Bypass - CVE:CVE-2025-47227 | Log | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | cad6f1c8c6d44ef59929e6532c62d330 | 100849 | ScriptCase - Command Injection - CVE:CVE-2025-47228 | Log | Disabled | This is a New Detection |
| Cloudflare Managed Ruleset | e7464139fd3e44938b56716bef971afd | 100872 | WordPress:Plugin:InfiniteWP Client - Missing Authorization - CVE:CVE-2020-8772 | Log | Block | This is a New Detection |
| Cloudflare Managed Ruleset | 0181ebb2cc234f2d863412e1bab19b0b | 100873 | Sar2HTML - Command Injection - CVE:CVE-2025-34030 | Log | Block | This is a New Detection |
| Cloudflare Managed Ruleset | 34d5c7c7b08b40eaad5b2bb3f24c0fbe | 100875 | Zhiyuan OA - Remote Code Execution - CVE:CVE-2025-34040 | Log | Block | This is a New Detection |
