---
title: Packet captures · Cloudflare Magic Firewall docs
description: "Cloudflare supports two types of packet captures: full and sample.
  Full packet captures is the default behavior."
lastUpdated: 2025-06-06T14:58:33.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-firewall/packet-captures/
  md: https://developers.cloudflare.com/magic-firewall/packet-captures/index.md
---

Cloudflare supports two types of packet captures: full and sample. Full packet captures is the default behavior.

Note

The maximum packet capture runtime is 24 hours for sample and full packet captures.

## Sample packet captures

Sample packet captures collects historical data on network traffic that has already passed through Cloudflare's network. It will not collect any new traffic sent to Cloudflare's network after the packet capture has started. All sample packet captures will complete immediately after they are started because they query historical traffic data.

Sample packet captures can be viewed in the Cloudflare dashboard. They only include the first 160 bytes of data. This is useful for capturing packet headers, but will not provide detailed packet data. The sample data is collected across all Cloudflare's data centers to build a PCAP file. This allows you to get a global picture of traffic across all data centers.

You should use full packet captures if you need to collect data on packets that pass through your network less frequently.

## Full packet captures

Full packet captures will actively monitor Cloudflare's network for packets that match the selected filters, and will capture the matching packet data. The matching packet data is saved to a cloud storage bucket that is owned and configured by you.

Full packet captures will collect new traffic sent to Cloudflare's network after the packet capture has started, and include the full packet data. This type of capture cannot be viewed in the Cloudflare dashboard. You can download them from a cloud storage bucket and analyze them in Wireshark or another packet capture tool.

Refer to the articles in this section to learn how to use packet captures.

* [PCAPs bucket setup](https://developers.cloudflare.com/magic-firewall/packet-captures/pcaps-bucket-setup/)
* [Collect PCAPs](https://developers.cloudflare.com/magic-firewall/packet-captures/collect-pcaps/)
