---
title: Capitalization · Cloudflare Style Guide
description: Capitalize names of Cloudflare products, services, and features.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/capitalization/
  md: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/capitalization/index.md
---

**Capitalize names of Cloudflare products, services, and features.**

Each product, service, and feature should be properly spelled and capitalized when used in any content, both to ensure consistency across all channels and to differentiate common performance and security technologies (for example: load balancing, bot management, and web application firewalls) from specific Cloudflare solutions (for example: Cloudflare Load Balancing, Cloudflare Bot Management, and Cloudflare Web Application Firewall).

| ✅ | ❌ | Rationale |
| - | - | - |
| This interactive demo provides three different scenarios on how to utilize **Cloudflare Rate Limiting** to protect your endpoints from suspicious requests. | This interactive demo provides three different scenarios on how to utilize **rate limiting** to protect your endpoints from suspicious requests. | This demo is specific to a Cloudflare product (Cloudflare Rate Limiting), not a tutorial on utilizing generic rate limiting. |
| The **Cloudflare Web Application Firewall (WAF)** sits on the same anycast network that powers our global CDN, HTTP/2, and web optimization features. | Our **web application firewall** sits on the same anycast network that powers our global CDN, HTTP/2, and web optimization features. | Cloudflare Web Application Firewall (WAF) is a specific product we offer and should be capitalized and identified with the Cloudflare name. |

## Example of capitalization and pluralization usage for the Waiting Room

**When to use Waiting Room capitalized and singular:**

* Naming the product: *Waiting Room keeps wait times low by dynamically managing traffic.*
* Page title: *Access Waiting Room*
* Preceded by “Cloudflare”: *Cloudflare Waiting Room allows organizations to…*
* Preceding a feature name: *Waiting Room Event Scheduling*

**When to waiting room(s) lower-case and in singular or plural:**

* Used as an object: *Your waiting room will begin queueing all visitors and will not allow any visitors to the path protected by your waiting room.*
* Capitalize only the first word when at the beginning of a sentence: *Waiting rooms are enabled on all subpaths, meaning you might be sending more traffic to your waiting room than anticipated.*
* Capitalize only the first word when it is the title of a subsection: *### Waiting room template*

## Common capitalization conventions

| ✅ | ❌ | Rationale |
| - | - | - |
| CAPTCHA, reCAPTCHA | Captcha, captcha, recaptcha, Recaptcha | A **CAPTCHA** is a puzzle used to challenge users and ensure they are not bots. |
| cloud | Cloud, "cloud" | The **cloud** is a network of remote servers used to store and maintain data. |
| DDoS | ddos, DDOS | A **DDoS** attack is a malicious attempt to disrupt normal traffic of a targeted server. |
| denial-of-service (DoS) | denial of service, Denial-of-Service, Denial-Of-Service, Denial of Service, dos, Dos, DOS | DDoS is a type of **DoS** attack. |
| Enterprise, enterprise | ent, ENT | Capitalized - Refers to the official Cloudflare **Enterprise** Plan or a customer on the **Enterprise** plan. Sentence-case - All Enterprise customers are enterprise companies, but not all enterprises are Enterprise customers. |
| Internet | internet | Disabling this option may cause all devices to lose **Internet** connectivity. |
| SSL | ssl | **SSL** is an encryption-based Internet security protocol. |
| TLS | tls | **TLS** is a security protocol designed to facilitate privacy and data security for communications over the Internet.. |
| WAF | waf | **WAF** is a security system that helps protect web applications by filtering and monitoring HTTP traffic between a web application and the Internet. |
| Zero Trust | zero trust | **Cloudflare** Access is a Zero Trust solution that secures inbound connections to your protected applications. |

## Headings

For headings, only the first letter of the first word should be capitalized. Normal capitalization rules still apply to the rest of the sentence.
